unit aspxDelphiWCL.RadioButonListItemAttributes;

{

Copyright:  aspxDelphi.net All rights reserved. Use freely.

Zarko Gajic
http://aspxdelphi.net
http://delphi.about.com

}


interface

uses
  System.Web.UI, System.Web.UI.WebControls, System.IO, System.Text,
  System.ComponentModel;

type
  /// <summary>
  /// RadioButonListItemAttributes renders List Item attributes
  /// </summary>
  [DefaultProperty('Text')
  ,ToolboxData('<{0}:RadioButonListItemAttributes runat=server></{0}:RadioButonListItemAttributes>')]
  RadioButonListItemAttributes = class(System.Web.UI.WebControls.RadioButtonList)
  strict protected
    procedure Render(writer: HtmlTextWriter); override;
  end;

implementation

procedure RadioButonListItemAttributes.Render(writer: HtmlTextWriter);
var
  strAttributes: string;
  i: Integer;
  liHtmlTW: System.Web.UI.HtmlTextWriter;
  liSW: System.IO.StringWriter;
  liSB: System.Text.StringBuilder;
  endIndex: Integer;
  index: Integer;
  fixedHTML: string;
  htmlTW: System.Web.UI.HtmlTextWriter;
  SW: System.IO.StringWriter;
  SB: System.Text.StringBuilder;
begin
  SB := System.Text.StringBuilder.Create;
  SW := System.IO.StringWriter.Create(SB);
  htmlTW := System.Web.UI.HtmlTextWriter.Create(SW);
  inherited Render(htmlTW);
  fixedHTML := SB.ToString;

  liSB := System.Text.StringBuilder.Create;
  liSW := System.IO.StringWriter.Create(liSB);
  liHtmlTW := System.Web.UI.HtmlTextWriter.Create(liSW);
  i := 0;  index := 0;
  while (i <= (Self.Items.Count - 1)) do
  begin
    if (Self.Items[i].Attributes['Visible'] = 'False') then
    begin
      index := fixedHTML.IndexOf('<tr>', index);
      endIndex := (fixedHTML.IndexOf('</tr>', index) + '</tr>'.Length);
      fixedHTML := fixedHTML.Remove(index, (endIndex - index));
    end
    else
    begin
      index := (fixedHTML.IndexOf('<input ', index) + '<input '.Length);
      liSB.Remove(0, liSB.Length);
      Self.Items[i].Attributes.Render(liHtmlTW);
      strAttributes := (liSB.ToString + ' ');
      fixedHTML := fixedHTML.Insert(index, strAttributes);
    end;
    i := i + 1;
  end;
  writer.Write(fixedHTML);
end;

end.
